/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import net.codecrete.usb.linux.Linux;

class IO {
    private static final Linker linker = Linker.nativeLinker();
    private static final FunctionDescriptor ioctl$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS);
    private static final MethodHandle ioctl$MH = linker.downcallHandle(linker.defaultLookup().find("ioctl").get(), ioctl$FUNC, Linux.ERRNO_STATE, Linker.Option.firstVariadicArg(2));
    private static final FunctionDescriptor open$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
    private static final MethodHandle open$MH = linker.downcallHandle(linker.defaultLookup().find("open").get(), open$FUNC, Linux.ERRNO_STATE);

    private IO() {
    }

    static int ioctl(int fd, long request, MemorySegment segment, MemorySegment errno2) {
        try {
            return ioctl$MH.invokeExact(errno2, fd, request, segment);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static int open(MemorySegment file, int oflag, MemorySegment errno2) {
        try {
            return open$MH.invokeExact(errno2, file, oflag);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

