/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.MemorySegment;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbStallException;
import net.codecrete.usb.UsbTimeoutException;
import net.codecrete.usb.macos.gen.iokit.IOKit;
import net.codecrete.usb.macos.gen.mach.mach;

public class MacosUsbException
extends UsbException {
    public MacosUsbException(String message, int errorCode) {
        super(String.format("%s: %s", message, MacosUsbException.machErrorMessage(errorCode)), errorCode);
    }

    private static String machErrorMessage(int errorCode) {
        MemorySegment msg = mach.mach_error_string(errorCode);
        return msg.getUtf8String(0L);
    }

    static void throwException(int errorCode, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        if (errorCode == IOKit.kIOUSBPipeStalled()) {
            throw new UsbStallException(formattedMessage);
        }
        if (errorCode == IOKit.kIOUSBTransactionTimeout()) {
            throw new UsbTimeoutException(formattedMessage);
        }
        throw new MacosUsbException(formattedMessage, errorCode);
    }

    static void throwException(String message, Object ... args) {
        throw new UsbException(String.format(message, args));
    }
}

