/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.analytics;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.merlyn.core.analytics.AnalyticsLogger;
import org.merlyn.core.audio.SpeechSession;
import org.merlyn.core.audio.SpeechSessionImpl;
import org.merlyn.core.audio.SpeechSessionKt;
import org.merlyn.dataplatform.EventBuilder;
import org.merlyn.dataplatform.ModalityType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\u0007*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/merlyn/core/analytics/AnalyticsSpeechSessionResultLogger;", "", "analyticsLogger", "Lorg/merlyn/core/analytics/AnalyticsLogger;", "<init>", "(Lorg/merlyn/core/analytics/AnalyticsLogger;)V", "logResult", "", "session", "Lorg/merlyn/core/audio/SpeechSessionImpl;", "state", "Lorg/merlyn/core/audio/SpeechSession$State;", "populate", "Lorg/merlyn/dataplatform/EventBuilder;", "sdkCore"})
public final class AnalyticsSpeechSessionResultLogger {
    @NotNull
    private final AnalyticsLogger analyticsLogger;

    public AnalyticsSpeechSessionResultLogger(@NotNull AnalyticsLogger analyticsLogger) {
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        this.analyticsLogger = analyticsLogger;
    }

    /*
     * WARNING - void declaration
     */
    public final void logResult(@NotNull SpeechSessionImpl session, @NotNull SpeechSession.State state) {
        EventBuilder eventBuilder;
        AnalyticsLogger analyticsLogger;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Result<TimedValue<String>> result = state.getResult-xLWZpok();
        if (result == null) {
            return;
        }
        Object result2 = result.unbox-impl();
        AnalyticsLogger analyticsLogger2 = this.analyticsLogger;
        if (Result.isSuccess-impl((Object)result2)) {
            void $this$logResult_u24lambda_u241;
            EventBuilder eventBuilder2;
            Object object = result2;
            ResultKt.throwOnFailure((Object)object);
            TimedValue timedValue = (TimedValue)object;
            String transcript2 = (String)timedValue.component1();
            long transcriptTime = timedValue.component2-UwyO8pc();
            EventBuilder eventBuilder3 = eventBuilder2 = EventBuilder.Companion.create("SpeechSession", session.getRequestId());
            AnalyticsLogger analyticsLogger3 = analyticsLogger2;
            boolean bl = false;
            this.populate((EventBuilder)$this$logResult_u24lambda_u241, session, state);
            kotlin.time.Duration duration = SpeechSessionKt.getCloseToTranscriptTime(state);
            if (duration != null) {
                long it = duration.unbox-impl();
                boolean bl2 = false;
                $this$logResult_u24lambda_u241.set("streamCloseToTranscriptReceivedTime", kotlin.time.Duration.getInWholeMilliseconds-impl((long)it));
            }
            $this$logResult_u24lambda_u241.set("startToTranscriptReceivedTime", kotlin.time.Duration.getInWholeMilliseconds-impl((long)transcriptTime));
            if (SpeechSessionKt.isTranscript(session)) {
                $this$logResult_u24lambda_u241.set("transcriptSessionMode", "active");
            }
            $this$logResult_u24lambda_u241.setEncrypted("transcript", transcript2);
            analyticsLogger = analyticsLogger3;
            eventBuilder = eventBuilder2;
        } else {
            void $this$logResult_u24lambda_u242;
            EventBuilder eventBuilder4;
            Throwable throwable = Result.exceptionOrNull-impl((Object)result2);
            Intrinsics.checkNotNull((Object)throwable);
            Throwable cause = throwable;
            EventBuilder transcriptTime = eventBuilder4 = EventBuilder.Companion.create("SpeechSession.Error", session.getRequestId());
            AnalyticsLogger analyticsLogger4 = analyticsLogger2;
            boolean bl = false;
            this.populate((EventBuilder)$this$logResult_u24lambda_u242, session, state);
            String string = cause.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            $this$logResult_u24lambda_u242.set("errorClass", string);
            String string2 = cause.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            $this$logResult_u24lambda_u242.set("errorMessage", string2);
            analyticsLogger = analyticsLogger4;
            eventBuilder = eventBuilder4;
        }
        analyticsLogger.log(eventBuilder);
    }

    private final void populate(EventBuilder $this$populate, SpeechSessionImpl session, SpeechSession.State state) {
        $this$populate.setModalityType(ModalityType.PTT_VOICE);
        Instant instant = Instant.now();
        long l = session.getCreateTime().elapsedNow-UwyO8pc();
        int n = kotlin.time.Duration.getNanosecondsComponent-impl((long)l);
        long l2 = kotlin.time.Duration.getInWholeSeconds-impl((long)l);
        Duration duration = Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        $this$populate.set("startTime", instant.minus(duration).toEpochMilli());
        kotlin.time.Duration duration2 = state.getOpenTime-FghU774();
        if (duration2 != null) {
            long it = duration2.unbox-impl();
            boolean bl = false;
            $this$populate.set("startToStreamOpenTime", kotlin.time.Duration.getInWholeMilliseconds-impl((long)it));
        }
        kotlin.time.Duration duration3 = state.getCloseTime-FghU774();
        if (duration3 != null) {
            long it = duration3.unbox-impl();
            boolean bl = false;
            $this$populate.set("startToStreamCloseTime", kotlin.time.Duration.getInWholeMilliseconds-impl((long)it));
        }
        if (state.getBytesSent() > 0) {
            $this$populate.set("audioBytesSent", state.getBytesSent());
            $this$populate.set("audioDuration", kotlin.time.Duration.getInWholeMilliseconds-impl((long)SpeechSessionKt.audioDuration(state, session.getAudioFormat())));
        }
    }
}

