/*
 * Decompiled with CFR 0.152.
 */
package com.nfeld.jsonpathkt.cache;

import com.nfeld.jsonpathkt.JsonPath;
import com.nfeld.jsonpathkt.cache.Cache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001f\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00100\u000fH\u0000\u00a2\u0006\u0002\b\u0011R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/nfeld/jsonpathkt/cache/LRUCache;", "Lcom/nfeld/jsonpathkt/cache/Cache;", "maxCacheSize", "", "(I)V", "map", "Lcom/nfeld/jsonpathkt/cache/LRUCache$LRUMap;", "get", "Lcom/nfeld/jsonpathkt/JsonPath;", "path", "", "put", "", "jsonPath", "toList", "", "Lkotlin/Pair;", "toList$jsonpathkt", "Companion", "LRUMap", "jsonpathkt"})
public final class LRUCache
implements Cache {
    private final LRUMap map;
    private final int maxCacheSize;
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public synchronized JsonPath get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (JsonPath)this.map.get((Object)path);
    }

    @Override
    public synchronized void put(@NotNull String path, @NotNull JsonPath jsonPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        this.map.put(path, jsonPath);
    }

    @NotNull
    public final List<Pair<String, JsonPath>> toList$jsonpathkt() {
        return MapsKt.toList((Map)this.map);
    }

    public LRUCache(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.map = new LRUMap();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010'\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/nfeld/jsonpathkt/cache/LRUCache$LRUMap;", "Ljava/util/LinkedHashMap;", "", "Lcom/nfeld/jsonpathkt/JsonPath;", "(Lcom/nfeld/jsonpathkt/cache/LRUCache;)V", "removeEldestEntry", "", "eldest", "", "jsonpathkt"})
    private final class LRUMap
    extends LinkedHashMap<String, JsonPath> {
        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<String, JsonPath> eldest) {
            return this.size() > LRUCache.this.maxCacheSize;
        }

        public LRUMap() {
            super(16, 0.75f, true);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/nfeld/jsonpathkt/cache/LRUCache$Companion;", "", "()V", "INITIAL_CAPACITY", "", "LOAD_FACTOR", "", "jsonpathkt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

