/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.diagnostics.checkers;

import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.diagnostics.Checker;
import org.merlyn.diagnostics.checkers.SystemData;
import org.merlyn.diagnostics.checkers.SystemDetailsChecker;
import org.merlyn.diagnostics.checkers.SystemProvider;
import org.merlyn.diagnostics.models.CheckResult;
import org.merlyn.diagnostics.models.CheckerConfig;
import org.merlyn.diagnostics.models.CheckerMessages;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/merlyn/diagnostics/checkers/SystemDetailsChecker;", "Lorg/merlyn/diagnostics/Checker;", "systemProvider", "Lorg/merlyn/diagnostics/checkers/SystemProvider;", "<init>", "(Lorg/merlyn/diagnostics/checkers/SystemProvider;)V", "check", "Lorg/merlyn/diagnostics/models/CheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "formatSize", "", "size", "", "configuration", "Lorg/merlyn/diagnostics/models/CheckerConfig;", "diagnostics"})
public final class SystemDetailsChecker
implements Checker {
    @NotNull
    private final SystemProvider systemProvider;

    public SystemDetailsChecker(@NotNull SystemProvider systemProvider) {
        Intrinsics.checkNotNullParameter((Object)systemProvider, (String)"systemProvider");
        this.systemProvider = systemProvider;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object check(@NotNull Continuation<? super CheckResult> $completion) {
        if (!($completion instanceof check.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ SystemDetailsChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.check((Continuation<? super CheckResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.systemProvider.provide((Continuation<? super SystemData>)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                system = (SystemData)v0;
                v1 = NetworkInterface.getNetworkInterfaces();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"getNetworkInterfaces(...)");
                networks = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(v1)))), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, check$lambda$0(java.net.NetworkInterface ), (Ljava/net/NetworkInterface;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, check$lambda$1(java.net.NetworkInterface ), (Ljava/net/NetworkInterface;)Ljava/util/Enumeration;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, check$lambda$2(java.util.Enumeration ), (Ljava/util/Enumeration;)Ljava/lang/Iterable;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, check$lambda$3(java.net.InetAddress ), (Ljava/net/InetAddress;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, check$lambda$4(java.net.InetAddress ), (Ljava/net/InetAddress;)Ljava/lang/String;)()));
                var4_7 = new String[]{"Application stage: " + system.getAppEnv(), "Application version: " + system.getAppVersion(), "Device identifier: " + system.getDeviceId(), "Region: " + system.getRegion(), "Locale: " + system.getLocale(), "Java version: " + System.getProperty("java.version"), "Operating system: " + System.getProperty("os.name"), "Operating system version: " + System.getProperty("os.version")};
                return new CheckResult(true, 0, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])var4_7), (Iterable)networks));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String formatSize(long size) {
        String string = "%.1f";
        Object[] objectArray = new Object[]{(double)size / 1048576.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Override
    @NotNull
    public CheckerConfig configuration() {
        List list = CollectionsKt.listOf((Object)"System details could not be pulled");
        return new CheckerConfig(new CheckerMessages("System details successfully retrieved", list, "Checking system details"), CollectionsKt.emptyList());
    }

    private static final boolean check$lambda$0(NetworkInterface it) {
        return it.isUp();
    }

    private static final Enumeration check$lambda$1(NetworkInterface it) {
        return it.getInetAddresses();
    }

    private static final Iterable check$lambda$2(Enumeration it) {
        Intrinsics.checkNotNull((Object)it);
        ArrayList arrayList = Collections.list(it);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        return arrayList;
    }

    private static final boolean check$lambda$3(InetAddress it) {
        return !it.isLoopbackAddress();
    }

    private static final String check$lambda$4(InetAddress it) {
        return "Found address " + it.getHostAddress();
    }
}

